/*------------------------------------------------------------------------------*
 * File Name: WksControl.h	 													*
 * Creation: 														*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

class WksControl : public Dialog
{
public:
	WksControl() : Dialog(IDD_WC_WORKSHEETCONTROL, "WksControl")
	{
	}
	virtual int Create(HWND hParent = NULL)
	{
		InitMsgMap();// will be called from internal later
		int nRet = Dialog::Create(hParent);
		return nRet;
	}
protected:
///----------------- Message Map ----------------
	EVENTS_BEGIN
		ON_INIT(OnInitDialog)
		ON_CHANGE_PAGE( OnActivePageChange )
		ON_OK(OnOK)
		ON_CANCEL(OnCancel)
	EVENTS_END
///----------------------------------------------
	
	BOOL OnInitDialog()
	{
		m_wcWorksheetControl = GetItem(IDC_WC_WORKSHEET);
		Page pg = Project.Pages();
		string strName = pg.GetName();
		m_wcWorksheetControl.Attach(strName);
		m_wcWorksheetControl.Update();
		return TRUE;
	}

	BOOL OnActivePageChange( void )
	{
		Page pg = Project.Pages();
		string strName = pg.GetName();
		m_wcWorksheetControl.Attach(strName);
		m_wcWorksheetControl.Update();
		return TRUE;
	}		
	
	BOOL OnOK()
	{
		out_str("OK was clicked\n");
		return TRUE;
	}
	
	BOOL OnCancel()
	{
		out_str("Cancel was clicked\n");
		return TRUE;
	}

private:
	WorksheetControl m_wcWorksheetControl;
};
